function force = force_vs_extension_clutch_v2(substrate_stiffness, clutch_extension, state, N_unfolding_domains, linker_size, domain_contour_length, kT, L_p, talin_globular_domain_number, integrin_globular_domain_number, globular_domain_size)

% state - size of N_unfolding_domains
% state = 0 - folded (5nm domain), 1 - unfolded (wlc)
% the program accepts positive extensions only

if(length(state) ~= N_unfolding_domains)
    disp('Error: State array has a wrong size!')
end

if( sum(sum( clutch_extension < 0 )) > 0)
    disp('Error: Only positive extensions are accepted by the program!')
end


% total_wormlike_contour = sum( domain_contour_length(state ~= 0) ) + linker_size; 
% total_N_rigid = talin_globular_domain_number - N_unfolding_domains + sum(state == 0) + integrin_globular_domain_number; % total number of folded globular domains in a given state

total_wormlike_contour = linker_size; 
total_N_rigid = talin_globular_domain_number + 3 * sum(state == 1) + integrin_globular_domain_number; % total number of folded globular domains in a given state, here it is assumed that upon unfolding of R3 domain, it becomes a chain of 4 rigid bodies - alpha helices, with contour length of ~ 20 nm

size_1_extension = size(clutch_extension, 1);
size_2_extension = size(clutch_extension, 2);
force = zeros(size_1_extension, size_2_extension);

force_test = 1e-6 : 0.001 : 300; % [pN]
% force_test = 1e-6 : 0.0001 : 300; % [pN]
% options = optimset('TolX', 0.001);

%%% find the equilibrium force %%%
            
for i = 1 : size_1_extension
    parfor j = 1 : size_2_extension    
        if( clutch_extension(i, j) > 0.9999 * (total_wormlike_contour + total_N_rigid * globular_domain_size) + 100 / substrate_stiffness )
            force(i, j) = 100; % [pN]
        else
            zero_force_function = @(x) zero_delta_force_function(x, clutch_extension(i, j), substrate_stiffness, total_N_rigid, globular_domain_size, total_wormlike_contour, kT, L_p);
            delta_force = zero_force_function(force_test);
            [min_delta_force, index] = min(abs(delta_force));
            force(i, j) = force_test(index);
%             force(i, j) = fzero(zero_force_function, 50, options);
        end
    end
end

end